<?php
$pageName  = "Open an Account";
include $_SERVER['DOCUMENT_ROOT'] . "/auth/header.php";

if (@$_SESSION['acct_no']) {
    header("Location:./user/dashboard.php");
}

//   // force user to use pc
//   function isMobileDevice() {
//     return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo
// |fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i"
// , $_SERVER["HTTP_USER_AGENT"]);
// }

if (isset($_POST['regSubmit'])) {
    $acct_no = "1202" . (substr(number_format(time() * rand(), 0, '', ''), 0, 6));
    $firstname = $_POST['firstname'];
    $lastname = $_POST['lastname'];
    $acct_status = "hold";
    $acct_address = $_POST['address'];
    $acct_type = $_POST['acct_type'];
    $acct_gender = $_POST['acct_gender'];
    $state = $_POST['state'];
    $zipcode = $_POST['zipcode'];
    $acct_email = $_POST['acct_email'];
    $acct_phone = $_POST['phoneNumber'];
    $acct_password = $_POST['acct_password'];
    $confirmPassword = $_POST['confirmPassword'];
    $acct_pin = inputValidation($_POST['acct_pin']);
    $acct_dob = $_POST['acct_dob'];



    if ($acct_password !== $confirmPassword) {
        toast_alert('error', 'Password not matched');
    } else {
        //checking exiting email
        $usersVerified = "SELECT * FROM users WHERE acct_email=:acct_email or acct_phone=:acct_phone";
        $stmt = $conn->prepare($usersVerified);
        $stmt->execute([
            'acct_email' => $acct_email,
            'acct_phone' => $acct_phone
        ]);

        if ($stmt->rowCount() > 0) {
            toast_alert('error', 'Email or Phone Number Already Exit');
        } else {
            if (isset($_FILES['image'])) {
                $file = $_FILES['image'];
                $name = $file['name'];

                $path = pathinfo($name, PATHINFO_EXTENSION);

                $allowed = array('jpg', 'png', 'jpeg');


                $folder = "./assets/user/profile/";
                $n = $acct_no . $name;

                $destination = $folder . $n;
            }


            //INSERT INTO DATABASE
            $registered = "INSERT INTO users (firstname,lastname,acct_email,acct_password,acct_no,acct_status,acct_phone,acct_type,acct_gender,state,acct_address,zipcode,acct_dob,acct_pin,acct_image) VALUES(:firstname,:lastname,:acct_email,:acct_password,:acct_no,:acct_status,:acct_phone,:acct_type,:acct_gender,:state,:acct_address,:zipcode,:acct_dob,:acct_pin,:acct_image)";
            $reg = $conn->prepare($registered);
            $reg->execute([
                'firstname' => $firstname,
                'lastname' => $lastname,
                'acct_email' => $acct_email,
                'acct_password' => password_hash((string)$acct_password, PASSWORD_BCRYPT),
                'acct_no' => $acct_no,
                'acct_status' => $acct_status,
                'acct_phone' => $acct_phone,
                'acct_type' => $acct_type,
                'acct_gender' => $acct_gender,
                'state' => $state,
                'acct_address' => $acct_address,
                'zipcode' => $zipcode,
                'acct_dob' => $acct_dob,
                'acct_pin' => $acct_pin,
                'acct_image' => $n
            ]);




            $number = $acct_phone;
            $full_name = $firstname . " " . $lastname;
            $APP_NAME = WEB_TITLE;


            if ($page['twillio_status'] == '1') {
                $messageText = "Dear " . $full_name . ", Thank you for registering at " . $APP_NAME . ". Kindly wait while your account is activated, Thanks ";

                $sendSms->sendSmsCode($number, $messageText);
            }

            if (true) {


                $full_name = $firstname . " " . $lastname;
                $APP_NAME = WEB_TITLE;
                $APP_URL = WEB_URL;
                $SITE_ADDRESS = $page['url_address'];
                $message = $sendMail->RegisterMsg($full_name, $acct_no, $acct_status, $APP_NAME, $APP_URL, $SITE_ADDRESS);
                // User Email
                $subject = "Welcome to " . "-" . $APP_NAME;
                $email_message->send_mail($acct_email, $message, $subject);



                $msg1 = "
                <div class='alert alert-warning'>
                
                <script type='text/javascript'>
                     
                        function Redirect() {
                        window.location='./login.php';
                        }
                        document.write ('');
                        setTimeout('Redirect()', 6000);
                     
                        </script>
                        
                <center><img src='../assets/images/loading.gif' width='180px'  /></center>
                 
                <center>	<strong style='color:black;'>Sending Account Registration Request...
                       </strong></center>
                
                  </div>
                ";
            } else {
                toast_alert("error", "Invalid details");
            }
        }
    }
}
?>

<!--  -->

<!-- App Header -->
<div class="appHeader no-border transparent position-absolute">
    <div class="left">

    </div>
    <div class="pageTitle"></div>
    <div class="right">
    </div>
</div>
<!-- * App Header -->

<div id="appCapsule">

    <div class="authincation section-padding">
        <div class="container">
            <div class="row justify-content-center h-100 align-items-center">
                <div class="col-md-8">
                    <div class="auth-form card">
                        <div class="card-body">
                            <h2>Online Account Opening</h2>
                            <p>Want to open a bank account, but have no time to visit the branch and fill in the
                                form?
                                Knowing that your time is precious, we are happy to introduce the new service Online
                                Account
                                Opening. Ready to start banking with <?= $pageTitle ?>? Complete the form below and
                                apply
                                for your account
                                now!</p>
                        </div>
                    </div><br>
                    <div class="auth-form card">
                        <div class="card-body">


                            <?php if (isset($msg1)) echo $msg1; ?>

                            <form method="post" class="signin_validate row g-3">
                                <h4 class="text-success" id="register-error"></h4>
                                <div class="col-md-6">
                                    <label class="form-label">First Name</label>
                                    <input type="text" class="form-control" required placeholder="First Name" name="firstname">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Last Name</label>
                                    <input type="text" class="form-control" required placeholder="Last Name" name="lastname">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" required placeholder="hello@example.com" name="acct_email">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Phone Number</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                +
                                            </span>
                                        </div>
                                        <input type="text" inputmode="numeric" required pattern="[0-9]+" minlength="9" maxlength="12" autocomplete="off" placeholder="1 440 941 4254" class="form-control wizard-required" name="phoneNumber">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Home Address</label>
                                    <input type="text" class="form-control" required placeholder="Home Address" name="address">



                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">State</label>
                                    <input type="text" class="form-control" required placeholder="State" name="state">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">City</label>
                                    <input type="text" class="form-control wizard-required" placeholder="City" id="city" name="city">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Zipcode/postal code</label>

                                    <input type="text" inputmode="numeric" required pattern="[0-9]+" minlength="4" maxlength="6" autocomplete="off" class="form-control wizard-required" placeholder="100001" id="zipcode" name="zipcode">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Gender</label>
                                    <select name="acct_gender" required class="form-control" data-width='100%'>
                                        <option value="">Select Gender Type</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Account Type</label>
                                    <select name="acct_type" required class="form-control" data-width='100%'>
                                        <option value="">Select Account Type</option>
                                        <option value="Savings">Savings Account</option>
                                        <option value="Current">Current Account</option>
                                        <option value="Checking">Checking Account</option>
                                        <option value="Fixed Deposit">Fixed Deposit</option>
                                        <option value="Non Resident">Non Resident Account</option>
                                        <option value="Joint Account">Joint Account</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Upload Picture</label>
                                    <input type="file" id="input-file-max-fs" required class="form-control" name="image" data-max-file-size="2M" />
                                    <input type="hidden" name="MAX_FILE_SIZE" value="10485760" />
                                </div>


                                <div class="col-md-6">
                                    <label class="form-label">Date of Birth</label>
                                    <input type="date" class="form-control" required placeholder="Date of Birth" name="acct_dob">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">4 Digit Transaction Pin</label>
                                    <input type="text" class="form-control" inputmode="numeric" required pattern="[0-9]+" maxlength="4" autocomplete="off" style="margin-bottom: 5px" placeholder="****" name="acct_pin">

                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Password</label>
                                    <input type="password" class="form-control" maxlength="20" required placeholder="Password" name="acct_password">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Confirm Password</label>
                                    <input type="password" class="form-control" maxlength="20" required placeholder="Confirm Password" name="confirmPassword">

                                </div>

                                <br>



                                <div class="d-grid gap-2">
                                    <button type="submit" class="btn btn-primary" name="regSubmit">Create
                                        new account</button>
                                </div>
                            </form>
                            <div class="text-center">
                                <p class="mt-3 mb-0"> <a class="text-primary" href="./login.php">Sign in</a> to your
                                    account</p>
                            </div>
                        </div>



                    </div>
                    <br>

                    <ul class="listview image-listview text inset no-line">
                        <li>
                            <div class="item">
                                <div class="in">
                                    <div>
                                        Theme Mode
                                    </div>
                                    <div class="form-check form-switch  ms-2">
                                        <input class="form-check-input dark-mode-switch" type="checkbox" id="darkmodeSwitch">
                                        <label class="form-check-label" for="darkmodeSwitch"></label>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--  -->

<?php
include $_SERVER['DOCUMENT_ROOT'] . "/auth/footer.php";

?>